open Ast
open Lexing
open Parsing
open Core.Std
open Codegen

let inchan = if Array.length Sys.argv > 1 
             then In_channel.create ~binary:true Sys.argv.(1)
             else In_channel.stdin
;;

(* 
let _ =
    let lexbuf = Lexing.from_channel inchan in 
    let program = Parser.program Scanner.token lexbuf in
    print_endline (Utils.string_of_program program)
*)

(* 
let _ =
    let lexbuf = Lexing.from_channel inchan in 
    let program = Parser.program Scanner.token lexbuf in
    let inferred_program = try Typechecker.type_check program
    with e -> Printf.printf "Error: %s\n" (Exn.to_string e); exit 1 in
    print_endline (Utils.string_of_aprogram inferred_program)
*)

let _ =
    let lexbuf = Lexing.from_channel inchan in 
    let program = Parser.program Scanner.token lexbuf in
    let inferred_program = try Typechecker.type_check program
    with e -> Printf.printf "Error: %s\n" (Exn.to_string e); exit 1 in
    let s_prog = try Codegen.js_of_aprog inferred_program
	with e -> Printf.printf "Error: %s\n" (Exn.to_string e); exit 1 in
    let outc = Out_channel.create "out.js" in
    Printf.fprintf outc "%s" s_prog; Out_channel.close outc
